/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef RE_THREAD_H
#define RE_THREAD_H
#include <QMainWindow>
#include <QtSerialPort/QSerialPort>
#include <QTimer>
#include <QThread>
#include <QtSerialPort/QSerialPort>
#include "gpioclass.h"

class RotaryEncoderThread : public QObject
{
    Q_OBJECT

public:
	explicit RotaryEncoderThread(QObject *parent = 0);
	~RotaryEncoderThread();
public slots:
    void process();
	 void stop_process();
	 void GPIO_Preparation();
	 void readRE();
	 void readMode();
     void acceleration();

signals:
	 //void finished();
	 //void triggerFunction();
	 void error(QString err);

	 void manual_mode();			//Rotary encoder mode
	 void transparent_mode();	//Serial pass-over mode
	 void knob_left();
	 void knob_right();
	 void knob_enter();
     void finished();
     void accelerate();
     void decelerate();

private:
    QTimer *RE_timer;
	 QTimer *RE_timer2;
     QTimer *Accel_Timer;
	 GPIOClass *Mode_GPIO;
	 GPIOClass *Enter_GPIO;
	 GPIOClass *B_GPIO;
	 GPIOClass *A_GPIO;
     GPIOClass *Relay_GPIO;

     int accelcounter = 0;
	 string enterval;
	 string Aval;
	 string Bval;
	 string modeval;
	 string oldA = "0";
	 string oldB = "0";
	 string oldMode = "asdf";	//giving this a weird value initially so the proper signal is emitted in readmode()
};

#endif // RE_THREAD_H
